#include <Adafruit_NeoPixel.h>

#define PIN 11 // Data pin connected to digital pin D11
#define NUMPIXELS 108 // The LED matrix has 108 pixels
#define BRIGHTNESS 30 // Brightness value, range 0 (darkest) to 255 (brightest)

Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
  pixels.begin(); // Initialize the NeoPixel matrix
  pixels.show();  // Initialize all LEDs to 'off'
}

void loop() {
  rainbowCycle(20); // Call the rainbow effect function, speed can be adjusted as needed
}

// Function to generate the rainbow effect
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256; j++) { // 256 steps of rainbow gradient
    for (i = 0; i < pixels.numPixels(); i++) {
      uint32_t color = Wheel((i * 256 / pixels.numPixels() + j) & 255);
      pixels.setPixelColor(i, dimColor(color, BRIGHTNESS));
    }
    pixels.show();
    delay(wait);
  }
}

// Function to generate rainbow colors
uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos; // Reverse the color order
  if (WheelPos < 85) {
    // Red to Yellow
    return pixels.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  }
  if (WheelPos < 170) {
    // Yellow to Green
    WheelPos -= 85;
    return pixels.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  }
  // Green to Blue
  WheelPos -= 170;
  return pixels.Color(0, WheelPos * 3, 255 - WheelPos * 3);
}

// Function to reduce color brightness
uint32_t dimColor(uint32_t color, uint8_t brightness) {
  uint8_t r = (color >> 16) & 0xFF;
  uint8_t g = (color >> 8) & 0xFF;
  uint8_t b = color & 0xFF;

  r = r * brightness / 255;
  g = g * brightness / 255;
  b = b * brightness / 255;

  return pixels.Color(r, g, b);
}