#include <Adafruit_NeoPixel.h>

#define PIN 11        // Data pin connected to digital pin D11
#define NUMPIXELS 108 // The LED matrix has 108 pixels
#define BRIGHTNESS 50 // Brightness value, range 0 (darkest) to 255 (brightest)

Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
  pixels.begin(); // Initialize the NeoPixel matrix
  pixels.setBrightness(BRIGHTNESS); // Set the brightness level
  pixels.show();  // Turn off all LEDs initially
}

void loop() {
  // Set each pixel to red
  for (int i = 0; i < NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(255, 0, 0)); // Set color to red
  }
  pixels.show(); // Update the matrix to display the color
  delay(1000); // Wait for 1 second

  // Set each pixel to green
  for (int i = 0; i < NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(0, 255, 0)); // Set color to green
  }
  pixels.show();
  delay(1000);

  // Set each pixel to blue
  for (int i = 0; i < NUMPIXELS; i++) {
    pixels.setPixelColor(i, pixels.Color(0, 0, 255)); // Set color to blue
  }
  pixels.show();
  delay(1000);
}