// 标准音名 + 频率（Hz）
#define N_C4  262
#define N_CS4 277
#define N_D4  294
#define N_DS4 311
#define N_E4  330
#define N_F4  349
#define N_FS4 370
#define N_G4  392
#define N_GS4 415
#define N_A4  440
#define N_AS4 466
#define N_B4  494

#define N_C5  523
#define N_CS5 554
#define N_D5  587
#define N_DS5 622
#define N_E5  659
#define N_F5  698
#define N_FS5 740
#define N_G5  784
#define N_GS5 831
#define N_A5  880
#define N_AS5 932
#define N_B5  988

#define N_C6  1047
#define N_CS6 1109
#define N_D6  1175
#define N_DS6 1245
#define N_E6  1319
#define N_F6  1397

// 节奏：120 BPM，1/8 拍 = 62.5 ms，2=1/4，4=1/2
const byte rhythm[] = {
   1,1,1,1,2, 1,1,2,
   1,1,1,1,2, 1,1,2,
   1,1,1,1,2, 1,1,2,
   1,1,1,1,2, 1,1,2,
};

// 对应音高（0=休止）
const int melody[] = {
   N_C5, N_C5, 0,  N_G5, N_G5, N_A5, N_A5, N_G5, 
   N_F5, N_F5, 0,  N_E5, N_E5, N_D5, N_D5, N_C5,
   N_C5, N_C5, 0,  N_G5, N_G5, N_A5, N_A5, N_G5, 
   N_F5, N_F5, 0,  N_E5, N_E5, N_D5, N_D5, N_C5
};

const int NOTES = sizeof(melody)/sizeof(int);
const int UNIT = 250;  // 1/8 拍基准 
const int BEEP_PIN = 21;

void playSong(const int *notes, const byte *durs, int len, int unit_ms) {
  for (int i = 0; i < len; i++) {
    int note = notes[i];
    int ms   = durs[i] * unit_ms;   // 1/8 拍 ≈ 62 ms
    if (note <= 0) {
      noTone(BEEP_PIN);
    } else {
      tone(BEEP_PIN, note);
    }
    delay(ms);
  }
  noTone(BEEP_PIN);
}
void setup() {
  pinMode(BEEP_PIN, OUTPUT);
  playSong(melody, rhythm, sizeof(melody)/sizeof(int), UNIT);     // 上电响一次
}

void loop() {
  delay(4000);     // 4 秒后重播
  playSong(melody, rhythm, sizeof(melody)/sizeof(int), UNIT);
}

