#define N_G4  392
#define N_A4  440
#define N_B4  494
#define N_C5  523
#define N_D5  587
#define N_E5  659
#define N_F5  698
#define N_G5  784
#define N_A5  880
#define N_B5  988
#define N_C6  1047

// 节奏：120 BPM，1/4 拍 = 125 ms，2 = 1/2 拍
const byte rhythm[] = {
  1,1,1,1, 1,1,2,    // 1-7
  1,1,1,1, 1,1,2,    // 8-14
  1,1,1,1, 1,1,2,    // 15-21
  1,1,2,    1,1,2    // 22-27
};

// 对应音高（0=休止）
const int melody[] = {
  N_C5, N_D5, N_E5, N_C5,   N_E5, N_C5, N_G5,
  N_C6, N_B5, N_A5, N_G5,   N_C5, N_E5, N_D5,
  N_C5, N_D5, N_E5, N_C5,   N_E5, N_C5, N_G4,
  N_C5, 0,    N_C5,          N_G4, 0,    N_C5
};

const int NOTES = sizeof(melody)/sizeof(int);

const int BEEP_PIN = 21;

void playCastle() {
  for (int i = 0; i < NOTES; i++) {
    int note = melody[i];
    int ms   = rhythm[i] * 125;   // 1/4 拍 = 125 ms
    if (note == 0) {
      noTone(BEEP_PIN);
    } else {
      tone(BEEP_PIN, note);
    }
    delay(ms);
  }
  noTone(BEEP_PIN);
}

void setup() {
  pinMode(BEEP_PIN, OUTPUT);
  playCastle();   // 上电响一次
}

void loop() {
  delay(4000);    // 4 秒后重播
  playCastle();
}
