#define N_C5  523
#define N_CS5 554
#define N_D5  587
#define N_E5  659
#define N_F5  698
#define N_FS5 740
#define N_G5  784
#define N_GS5 831
#define N_A5  880
#define N_AS5 932
#define N_B5  988
#define N_C6  1047
#define N_D6  1175
#define N_E6  1319

// 节奏：120 BPM，1 拍 = 500 ms，下面数字是 1/8 拍的个数
const byte rhythm[] = {  // 简谱节奏（8 分音符为 1）
  2,2,2,2,2,2,1,1,   // 1-8
  2,2,2,2,2,2,1,1,   // 9-16
  2,2,4,2,2,4,       // 17-22
  2,2,2,2,2,2,1,1,   // 23-30
  2,1,1,2,1,1,2,1,1,2,1,1,  // 31-42
  6,2,2,              // 43-45
  2,2,2,2,2,2,1,1,   // 46-53
  2,1,1,2,1,1,2,1,1,2,1,1,  // 54-65
  6,2,2               // 66-68
};

// 对应的音高（-1 代表休止符）
const int melody[] = {
  N_E5, N_E5,0, N_E5,0, N_C5, N_E5,0,   // 1-8
  N_G5,0,0, 0, N_G5,0,0, 0,             // 9-16
  N_C5,0,0, N_G5,0,0,                    // 17-22
  N_E5,0,0, N_A5,0, N_B5, N_AS5, N_A5,   // 23-30
  N_G5, N_E5, N_G5, N_A5, N_F5, N_G5, N_E5, N_C5, N_D5, N_B5,0,0, //31-42
  N_C5,0,0,                              // 43-45
  N_C5, N_C5,0, N_D5,0, N_E5, N_C5,0,   // 46-53
  N_A5, N_GS5, N_A5, N_F5, N_E5, N_D5, N_E5, N_C5, N_E5, N_G5,0,0, //54-65
  N_C5,0,0                               // 66-68
};

const int NOTES = sizeof(melody)/sizeof(int);

#define BEEP_PIN 21

void playMario() {
  for (int i = 0; i < NOTES; i++) {
    int note = melody[i];
    int ms   = rhythm[i] * (500/4);  // 1/8 拍 = 62.5 ms
    if (note == -1 || note == 0) {   // 休止符
      noTone(BEEP_PIN);
    } else {
      tone(BEEP_PIN, note);
    }
    delay(ms);
  }
  noTone(BEEP_PIN);   // 尾音关掉
}

void setup() {
  pinMode(BEEP_PIN, OUTPUT);
  playMario();        // 上电自动响一次
}

void loop() {
  delay(3000);        // 3 秒后重播
  playMario();
}
