const int button1 = 2;
const int button2 = 3;
const int button3 = 4;
const int redPin = 5;
const int greenPin = 6;
const int bluePin = 7;

void setup() {
  pinMode(button1,INPUT_PULLUP);
  pinMode(button2, INPUT_PULLUP);
  pinMode(button3, INPUT_PULLUP);
  pinMode(redPin, OUTPUT);
  pinMode(greenPin, OUTPUT);
  pinMode(bluePin, OUTPUT);
  digitalWrite(redPin, LOW);
  digitalWrite(greenPin, LOW);
  digitalWrite(bluePin, LOW);

}

void loop() {
  bool b1 = digitalRead(button1);
  bool b2 = digitalRead(button2);
  bool b3 = digitalRead(button3);
  
  // Reset all LEDs
  digitalWrite(redPin, LOW);
  digitalWrite(greenPin, LOW);
  digitalWrite(bluePin, LOW);
  
  // Check combinations
  if(b1 && b2 && b3) {
    // All buttons pressed = white
    digitalWrite(redPin, HIGH);
    digitalWrite(greenPin, HIGH);
    digitalWrite(bluePin, HIGH);
  } else if(b1 && b2) {
    // Buttons 1&2 = yellow
    digitalWrite(redPin, HIGH);
    digitalWrite(greenPin, HIGH);
  } else if(b1 && b3) {
    // Buttons 1&3 = magenta
    digitalWrite(redPin, HIGH);
    digitalWrite(bluePin, HIGH);
  } else if(b2 && b3) {
    // Buttons 2&3 = cyan
    digitalWrite(greenPin, HIGH);
    digitalWrite(bluePin, HIGH);
  } else if(b1) {
    // Button 1 = red
    digitalWrite(redPin, HIGH);
  } else if(b2) {
    // Button 2 = green
    digitalWrite(greenPin, HIGH);
  } else if(b3) {
    // Button 3 = blue
    digitalWrite(bluePin, HIGH);
  }
  
  delay(50); // Small delay for stability
}
