int ledPins[] = {8, 9, 10, 11};
int buttonPins[] = {2, 3, 4, 5};
int sequence[10];
int playerSequence[10];
int sequenceLength = 3;
int currentStep = 0;
bool playingSequence = true;
unsigned long startTime;

void setup() {
  for(int i = 0; i < 4; i++) {
    pinMode(ledPins[i], OUTPUT);
    pinMode(buttonPins[i], INPUT_PULLUP);
  }
  randomSeed(analogRead(0)); // Use analog noise for random seed
  generateSequence();
}

void loop() {
  if(playingSequence) {
    playSequence();
    playingSequence = false;
    startTime = millis();
  } else {
    checkPlayerInput();
  }
}

void generateSequence() {
  for(int i = 0; i < sequenceLength; i++) {
    sequence[i] = random(4);
  }
}

void playSequence() {
  for(int i = 0; i < sequenceLength; i++) {
    digitalWrite(ledPins[sequence[i]], HIGH);
    delay(500);
    digitalWrite(ledPins[sequence[i]], LOW);
    delay(250);
  }
}

void checkPlayerInput() {
  for(int i = 0; i < 4; i++) {
    if(digitalRead(buttonPins[i]) == HIGH) {
      digitalWrite(ledPins[i], HIGH);
      delay(200);
      digitalWrite(ledPins[i], LOW);
      
      if(i == sequence[currentStep]) {
        currentStep++;
        if(currentStep >= sequenceLength) {
          // Player won this round!
          sequenceLength++;
          currentStep = 0;
          playingSequence = true;
          delay(1000);
        }
      } else {
        // Game over - flash all LEDs
        for(int j = 0; j < 3; j++) {
          for(int k = 0; k < 4; k++) {
            digitalWrite(ledPins[k], HIGH);
          }
          delay(300);
          for(int k = 0; k < 4; k++) {
            digitalWrite(ledPins[k], LOW);
          }
          delay(300);
        }
        // Reset game
        sequenceLength = 3;
        currentStep = 0;
        playingSequence = true;
        delay(2000);
      }
    }
  }
}
